/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityTrackingParticleOption
implements ParticleOptions {
    protected int followedEntityID;
    protected double offsetXPosition;
    protected double offsetYPosition;
    protected double offsetZPosition;
    private final String type;
    public static final Codec<EntityTrackingParticleOption> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.STRING.fieldOf("type").forGetter(type -> type.type), (App)Codec.INT.fieldOf("followedEntityID").forGetter(followedEntityID -> followedEntityID.followedEntityID), (App)Codec.DOUBLE.fieldOf("offsetXPosition").forGetter(offsetXPosition -> offsetXPosition.offsetXPosition), (App)Codec.DOUBLE.fieldOf("offsetYPosition").forGetter(offsetYPosition -> offsetYPosition.offsetYPosition), (App)Codec.DOUBLE.fieldOf("offsetZPosition").forGetter(offsetZPosition -> offsetZPosition.offsetZPosition)).apply((Applicative)codecBuilder, EntityTrackingParticleOption::new));
    public static final ParticleOptions.Deserializer<EntityTrackingParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<EntityTrackingParticleOption>(){

        public EntityTrackingParticleOption fromCommand(ParticleType<EntityTrackingParticleOption> p_123689_, StringReader p_123690_) throws CommandSyntaxException {
            p_123690_.expect(' ');
            return new EntityTrackingParticleOption(p_123690_.readString(), p_123690_.readInt(), p_123690_.readDouble(), p_123690_.readDouble(), p_123690_.readDouble());
        }

        public EntityTrackingParticleOption fromNetwork(ParticleType<EntityTrackingParticleOption> p_123692_, FriendlyByteBuf p_123693_) {
            return new EntityTrackingParticleOption(p_123693_.m_130277_(), p_123693_.readInt(), p_123693_.readDouble(), p_123693_.readDouble(), p_123693_.readDouble());
        }
    };

    public EntityTrackingParticleOption(String type, int followedEntityID, double offsetXPosition, double offsetYPosition, double offsetZPosition) {
        this.type = type;
        this.followedEntityID = followedEntityID;
        this.offsetXPosition = offsetXPosition;
        this.offsetYPosition = offsetYPosition;
        this.offsetZPosition = offsetZPosition;
    }

    public void m_7711_(FriendlyByteBuf p_175809_) {
        p_175809_.m_130070_(this.type);
        p_175809_.writeInt(this.followedEntityID);
        p_175809_.writeDouble(this.offsetXPosition);
        p_175809_.writeDouble(this.offsetYPosition);
        p_175809_.writeDouble(this.offsetZPosition);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2i %.2d %.2d %.2d", Registry.f_122829_.m_7981_(this.m_6012_()), this.followedEntityID, this.offsetXPosition, this.offsetYPosition, this.offsetZPosition);
    }

    public ParticleType<EntityTrackingParticleOption> m_6012_() {
        return (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(this.type));
    }
}

